%% PLOTTING C60 SENSOR'S FREQUENCY RESPONSE

%%
clc;
clear all;
close all;


%% Selecting file
list1 = {'sensitivity_ideal.xlsx',...
         'sensitivity_NO_simul.xlsx',...
         'sensitivity_NO2_simul.xlsx',...
         'sensitivity_VDS_NO.xlsx',...
         'sensitivity_VDS_NO2.xlsx'...
         };    

[indx1,tf1] = listdlg('ListString', list1,'SelectionMode','single',...
                      'PromptString','Select file');
file = list1{indx1};    % Selected file
 
 
%% Extracting data
importfile(file);
[raws,columns] = size(data);

switch file
    case 'sensitivity_ideal.xlsx'
        IDS_NO = data.NO(:,2);          % [uA]
        fout_NO = data.NO(:,3);         % [MHz]
        
        IDS_NO2 = data.NO2(:,2);        % [uA]
        fout_NO2 = data.NO2(:,3);       % [MHz]
        
    
        %% Sorting data
        % NO
        [IDS_NO_sorted,I] = sort(IDS_NO);
        fout_NO_sorted = fout_NO(I);
        
        % NO2
        [IDS_NO2_sorted,I] = sort(IDS_NO2);
        fout_NO2_sorted = fout_NO2(I);
        
        
        %% Interpolating data
        grade = 1;
        
        % NO
        interpol_NO = polyfit(IDS_NO_sorted,fout_NO_sorted,grade)
        pol_fout_NO_sorted = polyval(interpol_NO,IDS_NO_sorted);
        
        % NO2
        interpol_NO2 = polyfit(IDS_NO2_sorted,fout_NO2_sorted,grade)
        pol_fout_NO2_sorted = polyval(interpol_NO2,IDS_NO2_sorted);
        
        
        %% Figures
        figure(1);
        p1 = plot(IDS_NO_sorted,fout_NO_sorted,'k*',...
                  IDS_NO_sorted,pol_fout_NO_sorted,'g-',...
                  'LineWidth',1.5,'MarkerSize',7.5);
        xlabel('I_{DS} [\muA]');
        ylabel('f_{out} [MHz]');
        xlim([14 23]);
        ylim([220 450]);
        legend('Extracted ideal data (NO)','Interpolating curve (NO)');
        legend('Location','northeast');
        hold on;
        grid on;
    
        print -depsc epsFig_sens_NO_ideal;
        
        
        figure(2);
        p2 = plot(IDS_NO2_sorted,fout_NO2_sorted,'b*',...
                  IDS_NO2_sorted,pol_fout_NO2_sorted,'m-',...
                  'LineWidth',1.5,'MarkerSize',7.5);
        xlabel('I_{DS} [\muA]');
        ylabel('f_{out} [MHz]');
        xlim([26 40]);
        ylim([220 450]);
        legend('Extracted ideal data (NO_{2})','Interpolating curve (NO_{2})');
        legend('Location','southeast');
        hold on;
        grid on;
        
        print -depsc epsFig_sens_NO2_ideal;
    


    case 'sensitivity_NO_simul.xlsx'
        IDS_NO_O_down = data.O_down(:,11);          % [uA]
        fout_NO_O_down = data.O_down(:,12);         % [MHz]
    
        IDS_NO_N_down = data.N_down(:,11);          % [uA]
        fout_NO_N_down = data.N_down(:,12);         % [MHz]
    
        IDS_NO_flat = data.flat(:,11);          % [uA]
        fout_NO_flat = data.flat(:,12);         % [MHz]
        
        IDS_NO_All = data.All(:,1);          % [uA]
        fout_NO_All = data.All(:,2);         % [MHz]
        
    
        %% Sorting data
        % NO O down
        [IDS_NO_O_down_sorted,I] = sort(IDS_NO_O_down);
        fout_NO_O_down_sorted = fout_NO_O_down(I);
        
        % NO N down
        [IDS_NO_N_down_sorted,I] = sort(IDS_NO_N_down);
        fout_NO_N_down_sorted = fout_NO_N_down(I);
        
        % NO flat
        [IDS_NO_flat_sorted,I] = sort(IDS_NO_flat);
        fout_NO_flat_sorted = fout_NO_flat(I);
        
        % NO flat
        [IDS_NO_All_sorted,I] = sort(IDS_NO_All);
        fout_NO_All_sorted = fout_NO_All(I);
    
    
        %% Interpolating data
        grade = 1;
        
        % NO O down
        interpol_NO_O_down = polyfit(IDS_NO_O_down_sorted,fout_NO_O_down_sorted,grade)
        pol_fout_NO_O_down_sorted = polyval(interpol_NO_O_down,IDS_NO_O_down_sorted);
        
        % NO N down
        interpol_NO_N_down = polyfit(IDS_NO_N_down_sorted,fout_NO_N_down_sorted,grade)
        pol_fout_NO_N_down_sorted = polyval(interpol_NO_N_down,IDS_NO_N_down_sorted);
    
        % NO N down
        interpol_NO_flat = polyfit(IDS_NO_flat_sorted,fout_NO_flat_sorted,grade)
        pol_fout_NO_flat_sorted = polyval(interpol_NO_flat,IDS_NO_flat_sorted);
    
        % NO All
        interpol_NO_All = polyfit(IDS_NO_All_sorted,fout_NO_All_sorted,grade)
        pol_fout_NO_All_sorted = polyval(interpol_NO_All,IDS_NO_All_sorted);
        
        
        %% Figures
%         figure(1);
%         p1 = plot(IDS_NO_O_down_sorted,fout_NO_O_down_sorted,'b*',...
%                   IDS_NO_O_down_sorted,pol_fout_NO_O_down_sorted,'r-',...
%                   'LineWidth',1.5,'MarkerSize',7.5);
%         xlabel('I_{DS} [\muA]');
%         ylabel('f_{out} [MHz]');
%         legend('Extracted simulation data (NO)','Interpolating curve (NO)')
%         legend('Location','southeast');
%         hold on;
%         grid on;
%         
%         
%         figure(2);
%         p2 = plot(IDS_NO_N_down_sorted,fout_NO_N_down_sorted,'b*',...
%                   IDS_NO_N_down_sorted,pol_fout_NO_N_down_sorted,'r-',...
%                   'LineWidth',1.5,'MarkerSize',7.5);
%         xlabel('I_{DS} [\muA]');
%         ylabel('f_{out} [MHz]');
%         legend('Extracted simulation data (NO)','Interpolating curve (NO)')        legend('Location','southeast');
%         hold on;
%         grid on;
%     
%         
%         figure(3);
%         p3 = plot(IDS_NO_flat_sorted,fout_NO_flat_sorted,'b*',...
%                   IDS_NO_flat_sorted,pol_fout_NO_flat_sorted,'r-',...
%                   'LineWidth',1.5,'MarkerSize',7.5);
%         xlabel('I_{DS} [\muA]');
%         ylabel('f_{out} [MHz]');
%         legend('Extracted simulation data (NO)','Interpolating curve (NO)')        legend('Location','southeast');
%         hold on;
%         grid on;
        
    
        figure(4);
        p4 = plot(IDS_NO_All_sorted,fout_NO_All_sorted,'r*',...
                  IDS_NO_All_sorted,pol_fout_NO_All_sorted,'c-',...
                  'LineWidth',1.5,'MarkerSize',7.5);
        xlabel('I_{DS} [\muA]');
        ylabel('f_{out} [MHz]');
        legend('Extracted simulation data (NO)','Interpolating curve (NO)')        
        legend('Location','northeast');
        xlim([14 23]);
        ylim([360 540]);
        hold on;
        grid on;
        
        print -depsc epsFig_sens_NO_simul;
    

    case 'sensitivity_NO2_simul.xlsx'
        IDS_NO2_O_down = data.O_down(:,11);          % [uA]
        fout_NO2_O_down = data.O_down(:,12);         % [MHz]
    
        IDS_NO2_N_down = data.N_down(:,11);          % [uA]
        fout_NO2_N_down = data.N_down(:,12);         % [MHz]
    
        IDS_NO2_flat = data.flat(:,11);          % [uA]
        fout_NO2_flat = data.flat(:,12);         % [MHz]
        
        IDS_NO2_All = data.All(:,1);          % [uA]
        fout_NO2_All = data.All(:,2);         % [MHz]
        
    
        %% Sorting data
        % NO O down
        [IDS_NO2_O_down_sorted,I] = sort(IDS_NO2_O_down);
        fout_NO2_O_down_sorted = fout_NO2_O_down(I);
        
        % NO N down
        [IDS_NO2_N_down_sorted,I] = sort(IDS_NO2_N_down);
        fout_NO2_N_down_sorted = fout_NO2_N_down(I);
        
        % NO flat
        [IDS_NO2_flat_sorted,I] = sort(IDS_NO2_flat);
        fout_NO2_flat_sorted = fout_NO2_flat(I);
        
        % NO All
        [IDS_NO2_All_sorted,I] = sort(IDS_NO2_All);
        fout_NO2_All_sorted = fout_NO2_All(I);
    
    
        %% Interpolating data
        grade = 1;
        
        % NO2 O down
        interpol_NO2_O_down = polyfit(IDS_NO2_O_down_sorted,fout_NO2_O_down_sorted,grade)
        pol_fout_NO2_O_down_sorted = polyval(interpol_NO2_O_down,IDS_NO2_O_down_sorted);
        
        % NO2 N down
        interpol_NO2_N_down = polyfit(IDS_NO2_N_down_sorted,fout_NO2_N_down_sorted,grade)
        pol_fout_NO2_N_down_sorted = polyval(interpol_NO2_N_down,IDS_NO2_N_down_sorted);
    
        % NO2 flat
        interpol_NO2_flat = polyfit(IDS_NO2_flat_sorted,fout_NO2_flat_sorted,grade)
        pol_fout_NO2_flat_sorted = polyval(interpol_NO2_flat,IDS_NO2_flat_sorted);
    
        % NO2 All
        interpol_NO2_All = polyfit(IDS_NO2_All_sorted,fout_NO2_All_sorted,grade)
        pol_fout_NO2_All_sorted = polyval(interpol_NO2_All,IDS_NO2_All_sorted);
        
        
        %% Figures
%         figure(1);
%         p1 = plot(IDS_NO2_O_down_sorted,fout_NO2_O_down_sorted,'b*',...
%                   IDS_NO2_O_down_sorted,pol_fout_NO2_O_down_sorted,'r-',...
%                   'LineWidth',1.5,'MarkerSize',7.5);
%         xlabel('I_{DS} [\muA]');
%         ylabel('f_{out} [MHz]');
%         legend('Extracted data','Interpolating curve')
%         legend('Location','southeast');
%         hold on;
%         grid on;
%         
%         
%         figure(2);
%         p2 = plot(IDS_NO2_N_down_sorted,fout_NO2_N_down_sorted,'b*',...
%                   IDS_NO2_N_down_sorted,pol_fout_NO2_N_down_sorted,'r-',...
%                   'LineWidth',1.5,'MarkerSize',7.5);
%         xlabel('I_{DS} [\muA]');
%         ylabel('f_{out} [MHz]');
%         legend('Extracted data','Interpolating curve')
%         legend('Location','southeast');
%         hold on;
%         grid on;
%     
%         
%         figure(3);
%         p3 = plot(IDS_NO2_flat_sorted,fout_NO2_flat_sorted,'b*',...
%                   IDS_NO2_flat_sorted,pol_fout_NO2_flat_sorted,'r-',...
%                   'LineWidth',1.5,'MarkerSize',7.5);
%         xlabel('I_{DS} [\muA]');
%         ylabel('f_{out} [MHz]');
%         legend('Extracted data','Interpolating curve')
%         legend('Location','southeast');
%         hold on;
%         grid on;
        
        
        i_0 = find(IDS_NO2_All_sorted == 0);
        IDS_NO2_All_sorted(i_0) = [];
        fout_NO2_All_sorted(i_0) = [];
        pol_fout_NO2_All_sorted(i_0) = [];
        
        % NO2 All
        interpol_NO2_All = polyfit(IDS_NO2_All_sorted,fout_NO2_All_sorted,grade)
        pol_fout_NO2_All_sorted = polyval(interpol_NO2_All,IDS_NO2_All_sorted);
        

        figure(4);
        p4 = plot(IDS_NO2_All_sorted,fout_NO2_All_sorted,'g*',...
                  IDS_NO2_All_sorted,pol_fout_NO2_All_sorted,'r-',...
                  'LineWidth',1.5,'MarkerSize',7.5);
%         p4.MarkerFaceColor = [0.8500 0.3250 0.0980];
        xlabel('I_{DS} [\muA]');
        ylabel('f_{out} [MHz]');
%         xlim([14 40]);
        ylim([360 540]);
        legend('Extracted simulation data (NO_{2})','Corrected interpolating curve')
        legend('Location','southeast');
        hold on;
        grid on;
        
%         print -depsc epsFig_sens_NO2_simul;
        print -depsc epsFig_sens_NO2_simul_corr;
    

    case 'sensitivity_VDS_NO.xlsx'
        VDS_NO_All = data.All(:,1);          % [V]
        fout_NO_All = data.All(:,2);         % [MHz]

        %% Sorting data
        % NO All
        [VDS_NO_All_sorted,I] = sort(VDS_NO_All);
        fout_NO_All_sorted = fout_NO_All(I);
    
        %% Interpolating data
        grade = 1;
                
        % NO All
        interpol_NO_All = polyfit(VDS_NO_All_sorted,fout_NO_All_sorted,grade)
        pol_fout_NO_All_sorted = polyval(interpol_NO_All,VDS_NO_All_sorted);
    
        %% Figures
        figure(4);
        p4 = plot(VDS_NO_All_sorted,fout_NO_All_sorted,'g*',...
                  VDS_NO_All_sorted,pol_fout_NO_All_sorted,'k-',...
                  'LineWidth',1.5,'MarkerSize',7.5);
        xlabel('V_{DS} [V]');
        ylabel('f_{out} [MHz]');
        legend('Extracted simulation data (NO)','Interpolating curve (NO)')        
        legend('Location','northeast');
%         xlim([14 23]);
%         ylim([360 540]);
        hold on;
        grid on;

        print -depsc epsFig_sens_VDS_NO;
    
    
    case 'sensitivity_VDS_NO2.xlsx'
        VDS_NO2_All = data.All(:,1);          % [uA]
        fout_NO2_All = data.All(:,2);         % [MHz]
        
        %% Sorting data
        % NO All
        [VDS_NO2_All_sorted,I] = sort(VDS_NO2_All);
        fout_NO2_All_sorted = fout_NO2_All(I);

        i_0 = find(VDS_NO2_All_sorted == 0);
        VDS_NO2_All_sorted(i_0) = [];
        fout_NO2_All_sorted(i_0) = [];
        
        %% Interpolating data
        grade = 1;

        % NO2 All
        interpol_NO2_All = polyfit(VDS_NO2_All_sorted,fout_NO2_All_sorted,grade)
        pol_fout_NO2_All_sorted = polyval(interpol_NO2_All,VDS_NO2_All_sorted);
        
        %% Figure
        figure(4);
        p4 = plot(VDS_NO2_All_sorted,fout_NO2_All_sorted,'*',...
                  VDS_NO2_All_sorted,pol_fout_NO2_All_sorted,'-',...
                  'LineWidth',1.5,'MarkerSize',7.5);
        xlabel('V_{DS} [V]');
        ylabel('f_{out} [MHz]');
%         xlim([14 40]);
%         ylim([360 540]);
        legend('Extracted simulation data (NO_{2})','Corrected interpolating curve')
        legend('Location','northeast');
        hold on;
        grid on;

        print -depsc epsFig_sens_VDS_NO2_corr;

end